<?php

namespace App\Notifications;

use App\Models\ForumThread;
use App\Models\ForumPost;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ThreadReplyNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $replier;
    protected $thread;
    protected $post;

    /**
     * Create a new notification instance.
     */
    public function __construct(User $replier, ForumThread $thread, ForumPost $post)
    {
        $this->replier = $replier;
        $this->thread = $thread;
        $this->post = $post;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     */
    public function toDatabase(object $notifiable): array
    {
        return [
            'replier_id' => $this->replier->id,
            'replier_name' => $this->replier->name,
            'replier_avatar' => $this->replier->avatar,
            'thread_id' => $this->thread->id,
            'thread_title' => $this->thread->title,
            'thread_slug' => $this->thread->slug,
            'board_slug' => $this->thread->board->slug,
            'post_id' => $this->post->id,
            'post_content_preview' => \Illuminate\Support\Str::limit(strip_tags($this->post->content), 100),
            'message' => "{$this->replier->name} replied to your thread \"{$this->thread->title}\"",
            'url' => route('forum.thread', [$this->thread->board->slug, $this->thread->slug]) . '#post-' . $this->post->id
        ];
    }
}